import React from 'react';
import './HallOfFame.scss';
import Grid from '../Grid/Grid';
import Section from '../Section/Section';

const { Row, Col } = Grid;

const HallOfFame = () => (
  <div className="hall-of-fame">
    <h2 className="h1 text_align_center">Hall da Fama</h2>
    <Section spacing="small">
      <Grid>
        <Row>
          <Col xl={3} xlOffset={2} md={3} mdOffset={1} xs={10} xsOffset={1}>
            <p>
              <img src={require('../HallOfFame/img/osterwalder.jpg')} alt="Alexander Osterwalder" />
            </p>
          </Col>
          <Col xl={5} md={7} mdOffset={0} xs={10} xsOffset={1}>
            <h3>Alexander Osterwalder</h3>
            <p>
              PhD suíço em sistemas de informação de gerenciamento, teórico de negócios, empresário, autor.
              Em 2008, ele originalmente propôs o modelo de negócios em tela e torná -lo popular com seu
              Livro do best -seller {''}
              <a
                target="_blank"
                rel="noopener noreferrer"
                href="https://www.amazon.com/dp/0470876417"
              >
                Geração de modelos de negócios
              </a>
              .
            </p>
            <p>
              Depois ele também propôs{' '}
              <a
                target="_blank"
                rel="noopener noreferrer"
                href="https://www.amazon.com/dp/1118968050"
              >
                Tela de proposição de valor
              </a>{' '}
              para uma compreensão mais profunda dos clientes e do design de produtos e serviços que
              atender às suas necessidades.
            </p>
          </Col>
        </Row>
      </Grid>
    </Section>
    <Section spacing="small">
      <Grid>
        <Row valign="center">
          <Col xl={3} xlOffset={2} md={3} mdOffset={1} xs={10} xsOffset={1}>
            <p>
              <img src={require('../HallOfFame/img/maurya.jpg')} alt="Ash Maurya" />
            </p>
          </Col>
          <Col xl={5} md={7} mdOffset={0} xs={10} xsOffset={1}>
            <h3>Ash Maurya</h3>
            <p>
              Ash adaptou o modelo de negócios de Osterwalder e otimizado para startups enxadas.Ele
              popularizando idéias de startups enxuta em icônico{' '}
              <a
                target="_blank"
                rel="noopener noreferrer"
                href="https://www.amazon.com/dp/1449305172/"
              >
                Startup enxuta
              </a>{' '}
              e{' '}
              <a
                target="_blank"
                rel="noopener noreferrer"
                href="https://www.amazon.com/dp/1101980524/"
              >
                Escalar magro
              </a>{' '}
              livros.
            </p>
          </Col>
        </Row>
      </Grid>
    </Section>
  </div>
);

export default HallOfFame;
